;;;Bosse-engineering                                                                                       
;;;Dipl.-Ing. Jrn Bosse                                                                                   
;;;Am Klei 5                                                                                               
;;;38458 Velpke                                                                                            
;;;Tel. 05364 / 989 677                                                                                    
;;;mobil. 0176 / 282 323 51                                                                                
;;;bosse@bosse-engineering.com                                                                             
;;;                                                                                                        
;;;--------------------------------------------------------------------------------------------------------
;;;Funktion c:OCL (ObjCopyByLayer)						        	           
;;;													   
;;;Es werden DWG-Dateien ausgewhlt. Pro DWG-Datei kann ein Layerfilter festgelegt werden, damit die 	   
;;;Objekte aus dem Modellbereich in die aktuelle Zeichnung kopiert werden knnen, die dem Layerfilter ent- 
;;;sprechen. Eine Datei kann fters in der Liste auftauchen, wenn z.B. unterschiedlichen Layerfilter zu-   
;;;gewiesen werden. Ein Layerfilter kann Komma-getrennt aus mehreren Eintrgen bestehen.		   
;;;													   
;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;globale Variablen:										   	   
;;;- JB_OCL$DCL$_[x]_po (Positionen der Dialogfenster)							   
;;;- JB_OCL$$TempPath => temporrer Verzeichnispfad fr Eigenschaftenliste			           
;;;                                                                              Jrn Bosse, 03.11.25      




;;;aufrufenden Funktionen
(defun c:OCL ( / )
  (JB_OCL)
  )


(defun c:ObjCopyByLayer ( / )
  (JB_OCL)
  )

;;;Definition der v_liste, wenn noch nicht vorhanden
(defun JB_OCL:v_liste ( / )  
  '(
     ( "DboxSettings" . (
                         ( "Dbox1" .
                            (                             
                             ("JB_1_l1" . nil);;;DWG-PfadListe mit jeweiligem Layerfilter
			     ("JB_1_l1_sel" . nil);;;Letztere EintragSEL
			     ("JB_1_to1" "0");;;Einfgepunkt picken
			     ("JB_1_to2" "0");;;Einfgung im aktuellen Bereich
			     
			     )
			  )
			 )
      ))
  )

;;;Pfad fr SIC-Datei in Windows-User
(defun JB_OCL:pfad_ini ( / )
  (strcat (JBf_String:Userpfad:WinUser
                           "LispData\\acad\\"     ;;;Hier ndern, wenn anderer Pfad gewnscht, z.B. MeineTools\\Sicherungen\\ => Der LAufwerksbuchstabe c:\\ wird automatisch gegen das Windows-Benutzerverzeichnis 
                           )"OCL_sic.lsp")  ;;;getauscht, z.B. c:\\User\\[WindowsUsername]\\LispData\\acad\\
  )

 

(defun JB_OCL:Intro ( / )
  (princ "\nerstellt durch Bosse-engineering - www.bosse-engineering.com\n")
  (princ "\n---------------------OCL(1.0), 03.11.25----------------------")
  (princ "\nObjCopyByLayer: Objekte kopieren aus Datei mit Layerfilter.  ")
  (princ "\n-------------------------------------------------------------")
  )


;;;Hauptfunktion
(defun JB_OCL ( / PFAD_INI V_LISTE)
  (vl-load-com)

  (setq pfad_ini (JB_OCL:pfad_ini))

  ;;;ab AutoCAD 2014, setzen von vertrauenswrdigen Pfaden fr Sicherungsdateien
  (if (JBf_AcadSystem:TrustedPaths?)
    (JBf_AcadSystem:TrustedPaths:Add (strcat(car(fnsplitl pfad_ini))"...")))

    (if (not(setq v_liste (if (findfile pfad_ini)
                          (load pfad_ini)nil)))
    (JBf_SIC:sichern
      (setq v_liste (JB_OCL:v_liste))pfad_ini nil))
  
  
  (JBf_init
    '(("CMDECHO" 0)
      ("DIMZIN" 3)
      ))  
  
  (JB_OCL:Intro)

  
  (if (not
            (or (and JB_OCL_$DCL$_File(findfile JB_OCL_$DCL$_File))
                (setq JB_OCL_$DCL$_File (JB_OCL:dcl:Write))))
        (progn
          (alert "Die DCL-Datei konnte nicht geschrieben werden.")
          (exit)))
  

  (JB_OCL:Dbox1 v_liste pfad_ini)
      
   
  (princ "\nEnde.")

  
  (JBf_Reinit)
  (princ)
  

)


(defun  JB_OCL:v_liste:DboxSettings:get (key v_liste / )
  (cdr(assoc key(cdr (assoc "DboxSettings" v_liste))))
)


(defun JB_OCL:v_liste:DboxSettings:put (key liste v_liste / DboxList) 
  (setq DboxList (cdr (assoc "DboxSettings" v_liste)))
  (setq DBoxList (JBf_list:subst:gc DBoxList liste key))
  (setq v_liste (JBf_list:subst:gc v_liste DBoxList "DboxSettings"))
  v_liste
  )



;;;DBox 1
(defun JB_OCL:Dbox1(v_liste pfad_ini / A DCLID OK SETTINGS&DBOX1)

  (setq Settings&Dbox1 (JB_OCL:v_liste:DboxSettings:get "Dbox1" v_liste))
    
  (while  (not(member ok '(1 99)))

    (setq DclId(JBf_Dcl:Load_dialog JB_OCL_$DCL$_File "JB_OCL_1" JB_OCL$DCL$_1_po))
    
    (JB_OCL:Dbox1:set)
    (JB_OCL:Dbox1:mode)
           
    (mapcar '(lambda(A)(action_tile A (strcat "(JB_OCL:Dbox1:action \""A"\")")))
      '("JB_1_l1"
	"JB_1_b1" "JB_1_b2" "JB_1_b3" "JB_1_b4"	"JB_1_b5"
	"JB_1_p1"
	"JB_1_to1" "JB_1_to2"
        "accept" "cancel"))

    (setq ok (start_dialog))
    (unload_dialog DclId)
    )

  (setq v_liste (JB_OCL:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
  (JBf_SIC:sichern v_liste pfad_ini nil)

  (if (= ok 1)
    (JB_OCL:DBox1:Copy)
    )	 
  )



;;;Action b1 - File auswhlen
(defun JB_OCL:Dbox1:action:b1 ( / FILEPATH L1LIST N X)
  
  (if (and(setq FilePath (getfiled "Whlen Sie eine DWG-Datei aus:"
			       (if (cdr(assoc "JB_1_l1_sel" Settings&dbox1))
				 (car(nth(cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
				 "")
			       "dwg" 4))
	  (or
	    (not(member (strcase FilePath)
			(mapcar 'strcase (mapcar 'car(cdr(assoc "JB_1_l1" Settings&dbox1))))))
	    (alert "Die Datei ist bereits ausgewhlt.")))
    (progn
      (setq n -1)
      (setq l1List (mapcar '(lambda(X)
				     (setq n (+ n 1))
				     (list n X))
				  (cdr(assoc "JB_1_l1" Settings&dbox1))))
	     (setq l1List (append l1List (list (list -1(cons FilePath
							     (list
							       (cons "FilterList" '("*"))
							       (cons "LastFilter" "*")))
						))))
	     (setq l1List (vl-sort l1List '(lambda(e1 e2)(< (car(cadr e1))(car(cadr e2))))))
	     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 (- (length l1List)(length (member -1 (mapcar 'car l1List))))"JB_1_l1_sel"))
	     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 (mapcar 'cadr l1List)"JB_1_l1"))
	     (JB_OCL:Dbox1:set)
	     (JB_OCL:Dbox1:mode)
	     )
	   )
  )


;;;Action b2 - File aus Liste lschen
(defun JB_OCL:Dbox1:action:b2 ( / N X)
  
  (setq n -1)
  (setq Settings&dbox1(JBf_list:subst:gc Settings&dbox1
			(mapcar 'cadr
				(vl-remove-if '(lambda(X)
						 (=(car X)(cdr(assoc "JB_1_l1_sel" Settings&dbox1))))
				  (mapcar '(lambda(X)
					     (setq n (+ n 1))
					     (list n X)
					     )
					  (cdr(assoc "JB_1_l1" Settings&dbox1))
					  )))"JB_1_l1"))

  (if (cdr(assoc "JB_1_l1" Settings&dbox1))
    (if (>(cdr(assoc "JB_1_l1_sel" Settings&dbox1))0)
      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 (-(cdr(assoc "JB_1_l1_sel" Settings&dbox1))1)"JB_1_l1_sel"))
      )
    (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 nil "JB_1_l1_sel")))
  (JB_OCL:Dbox1:set)
  (JB_OCL:Dbox1:mode)
  )


;;;Neuer oder genderter Filter einsubsten
(defun JB_OCL:Dbox1:action:b3-5:FilterSubst (FilterSub Sub / )
  
  (setq Sub (JBf_list:nth:change (cdr(assoc "JB_1_l1" Settings&dbox1))
	      (cons (car Sub) FilterSub) (cdr(assoc "JB_1_l1_sel" Settings&dbox1))))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 Sub "JB_1_l1"))
  (JB_OCL:Dbox1:set)
  (JB_OCL:Dbox1:mode)
  )
  


;;;Action b3 - Filter neu
(defun JB_OCL:Dbox1:action:b3 ( / Filter FilterSub Sub)
  (if (setq Filter (JB_OCL:DBox2 nil))
    (progn
      (setq Sub (nth (cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
      (setq FilterSub (cdr Sub))
      (if (not(member (strcase Filter)(mapcar 'strcase (cdr(assoc "FilterList" FilterSub)))))
	(setq FilterSub (JBf_list:subst:gc FilterSub
			  (vl-sort
			    (append (cdr(assoc "FilterList" FilterSub))(list Filter))
			    '(lambda(e1 e2)(< e1 e2))
			    )
			    "FilterList"))
	)
      (setq FilterSub (JBf_list:subst:gc FilterSub Filter "LastFilter"))
      (JB_OCL:Dbox1:action:b3-5:FilterSubst FilterSub Sub)
      )
    )
  )


;;;Action b4 - Filter ndern
(defun JB_OCL:Dbox1:action:b4 ( / )
  (setq Sub (nth (cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
  (setq FilterSub (cdr Sub))
  (setq Filter (nth (-(length (cdr (assoc "FilterList" FilterSub)))
		      (length (member (cdr(assoc "LastFilter" FilterSub))
				      (cdr(assoc "FilterList" FilterSub)))))
		    (cdr (assoc "FilterList" FilterSub))))

  (if (and(setq Filter (JB_OCL:DBox2 Filter))
	  (or (= Filter (cdr(assoc  "LastFilter" FilterSub)))
	      (or (not(member Filter (cdr(assoc "FilterList" FilterSub))))
		  (alert "Der Filter ist bereits vorhanden."))))
    (progn
      (setq FilterSub (JBf_list:subst:gc FilterSub
			(vl-sort(append(vl-remove-if '(lambda(X)
						(= X (cdr(assoc "LastFilter" FilterSub))))
				 (cdr(assoc "FilterList" FilterSub)))
			       (list Filter))
				'(lambda(e1 e2)
				   (< e1 e2)))
				"FilterList"))
      (setq FilterSub (JBf_list:subst:gc FilterSub Filter "LastFilter"))
      (JB_OCL:Dbox1:action:b3-5:FilterSubst FilterSub Sub)
      )
    )
  )



;;;;Action b5 - Filter lschen
(defun JB_OCL:Dbox1:action:b5 ( / FILTERSUB SUB)
  (setq Sub (nth (cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
  (setq FilterSub (cdr Sub))
  (setq FilterSub (JBf_list:subst:gc FilterSub
			(vl-sort(vl-remove-if '(lambda(X)
						(= X (cdr(assoc "LastFilter" FilterSub))))
				 (cdr(assoc "FilterList" FilterSub)))
				'(lambda(e1 e2)(< e1 e2)))
		    "FilterList"))
  (setq FilterSub (JBf_list:subst:gc FilterSub
		    (car(cdr(assoc "FilterList" FilterSub)))
		    "LastFilter"))
  (JB_OCL:Dbox1:action:b3-5:FilterSubst FilterSub Sub)
  )

;;;Filterauswahl
(defun JB_OCL:Dbox1:action:p1 ( / FILTERSUB SUB)
  (setq Sub (nth (cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
  (setq FilterSub (cdr Sub))
  (setq Filtersub (JBf_list:subst:gc FilterSub
		    (nth (atoi $value)(cdr(assoc "FilterList" FilterSub)))
		    "LastFilter"))
  (JB_OCL:Dbox1:action:b3-5:FilterSubst FilterSub Sub)
  )
  
  
			

;;;Action (Variable global in Aufrufender Funktion)
(defun JB_OCL:Dbox1:action (key /  )

  (cond ((= key "JB_1_l1")
	 (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 (atoi $value) "JB_1_l1_sel"))
	 (JB_OCL:Dbox1:set)
	 (JB_OCL:Dbox1:mode)
	 )

	((= key "JB_1_b1")
	 (JB_OCL:Dbox1:action:b1)
	 )

	((= key "JB_1_b2")
	 (JB_OCL:Dbox1:action:b2)
	 )

	((= key "JB_1_b3")
	 (JB_OCL:Dbox1:action:b3)
	 )

	((= key "JB_1_b4")
	 (JB_OCL:Dbox1:action:b4)
	 )

	((= key "JB_1_b5")
	 (JB_OCL:Dbox1:action:b5)
	 )

	((= key "JB_1_p1")
	 (JB_OCL:Dbox1:action:p1)
	 )

	((= key "JB_1_to1")
	 (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 $value "JB_1_to1"))
	 (JB_OCL:Dbox1:mode)
	 )

	((= key "JB_1_to2")
	 (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 $value "JB_1_to2"))
	 )
	 
	 	
        ((= key "cancel");;;Ende
	 (setq JB_OCL$DCL$_1_po (done_dialog 99))
         )
	((= key "accept");;;OK
	 
         (setq JB_OCL$DCL$_1_po (done_dialog 1))
         )
        )
  )

  
;;;Dbox1; Werte setzen 
(defun JB_OCL:Dbox1:set ( / X sub FilterSub)
  (if (cdr(assoc "JB_1_l1_sel" Settings&dbox1))
    (progn
      (setq Sub (nth (cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
      (setq FilterSub (cdr Sub))
      )
    )
  (start_list "JB_1_l1" 3)
  (mapcar 'add_list (mapcar '(lambda(X)
			       (strcat
				 (if (not(findfile(car X)))
				   "***"
				   "")
				 (JBf_String:PathFileName:reduce (car X)110))
			       )
	  (cdr(assoc "JB_1_l1" Settings&dbox1))))
  (end_list)

  (if (cdr(assoc "JB_1_l1_sel" Settings&dbox1))
    (set_tile "JB_1_l1" (itoa (cdr(assoc "JB_1_l1_sel" Settings&dbox1))))
    (set_tile "JB_1_l1" "")
    )

  (start_list "JB_1_p1" 3)
  (mapcar 'add_list (cdr(assoc "FilterList" FilterSub)))
  (end_list)
  (if FilterSub
    (set_tile "JB_1_p1"
	    (itoa(-(length (cdr(assoc "FilterList" FilterSub)))
		   (length (member (cdr(assoc "LastFilter" FilterSub))
				   (cdr(assoc "FilterList"  FilterSub)))))))
    (set_tile "JB_1_p1" "")
    )
  (set_tile "JB_1_to1"(cond
                        ((=(type(setq A(cdr(assoc "JB_1_to1" Settings&dbox1))))'STR)A)
                        ((=(type(setq A(car(cdr(assoc "JB_1_to1" Settings&dbox1)))))'STR)A)
                        ('T "0")
                      )
  )          
            ;(cdr(assoc "JB_1_to1" Settings&dbox1))) ;;TK-EDIT
  (set_tile "JB_1_to2"(cond
                        ((=(type(setq A(cdr(assoc "JB_1_to2" Settings&dbox1))))'STR)A)
                        ((=(type(setq A(car(cdr(assoc "JB_1_to2" Settings&dbox1)))))'STR)A)
                        ('T "0")
                      )
           ; (cdr(assoc "JB_1_to2" Settings&dbox1))) ;;TK-EDIT
  )
)

;;;DBOX 1, moden
(defun JB_OCL:Dbox1:mode ( / )
  (if (not (cdr(assoc "JB_1_l1_sel" Settings&dbox1)))
    (progn
      (mode_tile "JB_1_l1" 1)
      (mode_tile "JB_1_p1" 1)
      (mode_tile "JB_1_b2" 1)
      (mode_tile "JB_1_b1" 2)
      (mode_tile "JB_1_b3" 1)
      (mode_tile "JB_1_b4" 1)
      (mode_tile "JB_1_b5" 1)
      (mode_tile "accept" 1)
      )
    (progn
      (mode_tile "JB_1_l1" 0)
      (mode_tile "JB_1_p1" 0)
      (mode_tile "JB_1_b2" 0)
      (mode_tile "JB_1_b3" 0)
      (mode_tile "JB_1_b4" 0)
      (if (>(length (cdr(assoc "FilterList"(cdr(nth (cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1)))))))1)
	(mode_tile "JB_1_b5" 0)
	(mode_tile "JB_1_b5" 1)
	)
      (mode_tile "JB_1_b4" 2)
      (mode_tile "accept" 0)
      )
    )

  (if (=(cdr(assoc "JB_1_to1" Settings&dbox1))"0")
    (mode_tile "JB_1_to2" 1)
    (mode_tile "JB_1_to2" 0)
    )

  
  )

;;;LayerFilter mit OR verknpft
(defun JB_OCL:DBox1:Copy:Filter-p (layer FilterOrList / ok)
  (while (and FilterOrList (not ok))
    (setq ok(wcmatch layer(strcase (car FilterOrList)))
	  FilterOrList(cdr FilterOrList))
    )
  ok)


;;;Bounding-Box
(defun JB_OCL:DBox1:Copy:Bounding (vla-obj / p1 p2)
  (vla-GetBoundingBox vla-obj 'p1 'p2)
  (if (and p1 p2)
    (list (vlax-safearray->list p1)
	  (vlax-safearray->list p2)
      )
  )
)


(defun JB_OCL:DBox1:Copy:Done (vla-ObjList DBX BoundingList / AWS P1 P2 VLA-OBJLISTCOPY X)
  (setq vla-objListCopy
	 (vlax-safearray->list
	   (vlax-variant-value
	     (vla-CopyObjects
	       DBX
	       (vlax-safearray-fill
		 (vlax-make-safearray
		   vlax-vbObject
		   (cons 0 (-(length vla-ObjList) 1))
		   )
		 (reverse vla-ObjList))
	       (vla-get-ModelSpace(vla-get-activedocument
				    (vlax-get-acad-object)
				    ))
	       ))))


  (setq BoundingList (apply 'append BoundingList))


  (setq p1 (list(apply 'min (mapcar 'car BoundingList))
		(apply 'min (mapcar 'cadr BoundingList))
		0))
  (setq p2 (list(apply 'max (mapcar 'car BoundingList))
		(apply 'max (mapcar 'cadr BoundingList))
		0))

  (if (not(and(=(cdr(assoc "JB_1_to1" Settings&dbox1))"1")(cdr(assoc "JB_1_to2" Settings&dbox1))))
    (vla-zoomwindow(vlax-get-acad-object) (vlax-3d-point p1)(vlax-3d-point p2))
    )

  ;;;Wenn Schieben
  (if (=(cdr(assoc "JB_1_to1" Settings&dbox1))"1")
    (progn
      (setq aws (ssadd))
      (mapcar '(lambda(X)
		 (ssadd(vlax-vla-object->ename X)aws)
		 )
	      vla-objListCopy)

      (command "_.move" aws "" p1 pause)
      )
    )
      
  )
	 
  

;;;Ausfhren des Kopierens
(defun JB_OCL:DBox1:Copy ( / BLOCKLIST BOUNDINGLIST DBX DBXFILESUB FILTERORLIST VLA-OBJLIST)

  (setq DbXFileSub (nth(cdr(assoc "JB_1_l1_sel" Settings&dbox1))(cdr(assoc "JB_1_l1" Settings&dbox1))))
  (setq FilterOrList (JBf_String:Delimiter->List(cdr(assoc "LastFilter"(cdr DbXFileSub)))","))

  (if (setq DBX(JBf_DBX))
    (progn
      (if (JBf_DBX:Open DBX(car DbXFileSub))
	(progn
	  (JBf_progress_01:DBox:Start "Objekte auf Layer prfen" (vla-get-count(vla-get-modelSpace DBX)) nil)
	  (vlax-for vla-obj
		    (vla-get-modelSpace DBX)
	    (JBf_progress_01:DBox:Fortschritt)
	    (if (JB_OCL:DBox1:Copy:Filter-p(strcase(vla-get-layer vla-obj))FilterOrList)
	      (setq vla-ObjList (cons vla-obj vla-ObjList)
		    BoundingList (cons (JB_OCL:DBox1:Copy:Bounding vla-obj)BoundingList)))
	    )
	  (JBf_progress_01:DBox:End)
	  )
	(alert (strcat "Die Datei \"" (car DbXFileSub) "\" konnte nicht geffnet werden, Schreibschutz?"))
	)

      (if vla-ObjList
	(JB_OCL:DBox1:Copy:Done vla-ObjList DBX BoundingList)
	(alert "Es entsprach kein Objekt dem aktuellen Layerfilter.")
	)
	
      (JBf_DBX:Release DBX))
    )
  (reverse BlockList))


;;;DBox 2
(defun JB_OCL:Dbox2(Filter&Dbox2 / A DCLID OK)

  (if (not Filter&Dbox2)
    (setq Filter&Dbox2 "*")
    )

      
  (while  (not(member ok '(1 99)))

    (setq DclId(JBf_Dcl:Load_dialog JB_OCL_$DCL$_File "JB_OCL_2" JB_OCL$DCL$_2_po))
    
    (set_tile "JB_2_e1" Filter&Dbox2)
    (mode_tile "JB_2_e1" 2)
           
    (mapcar '(lambda(A)(action_tile A (strcat "(JB_OCL:Dbox2:action \""A"\")")))
      '("accept" "cancel"))

    (setq ok (start_dialog))
    (unload_dialog DclId)
    )
  (if (= ok 1)
    Filter&Dbox2
    )	 
  )


;;;DBox2 - action
(defun JB_OCL:Dbox2:action (key / )
  (cond ((= key "accept")
	 (setq Filter&Dbox2 (get_tile "JB_2_e1"))
	 (if (= Filter&Dbox2 "")
	   (setq Filter&Dbox2 "*")
	   )
	 (setq JB_OCL$DCL$_2_po (done_dialog 1))
	 )
	((= key "cancel")
	 (setq JB_OCL$DCL$_2_po (done_dialog 99))
	 )
	)
  )


;;;DCL-Datei schreiben
(defun JB_OCL:Dcl:Write ( / A  FILE)
  (if(and(setq JB_OCL_$DCL$_File(vl-filename-mktemp (strcat "OCL.dcl")))
         (setq file (open JB_OCL_$DCL$_File "w")))
    (progn
    (mapcar '(lambda(A)
               (write-line A file))
      (mapcar '(lambda(A)
                 (strcat "\n" A))
        '(
                "JB_OCL_1: dialog {label = \"Objekte kopieren aus Datei mit Layerfilter\";"
                ":boxed_column {label = \"DWG-Dateienliste mit Layerfilter\";"
                ":list_box {key = \"JB_1_l1\"; width = 120; label = \"bitte auswhlen\";}"
                ":popup_list {key = \"JB_1_p1\"; label = \"Layerfilter\";}"
                ":row {fixed_width = true;alignment = centered;"
                ":button {key = \"JB_1_b1\"; label = \"Datei &hinzufgen...\";}"
                ":button {key = \"JB_1_b2\"; label = \"Datei &entfernen\";}"
                ":button {key = \"JB_1_b3\"; label = \"Layerfilter hin&zufgen...\";}"
	        ":button {key = \"JB_1_b4\"; label = \"Layerfilter n&dern...\";}"
                ":button {key = \"JB_1_b5\"; label = \"Layerfilter ent&fernen\";}}"
                "}"
                ":row{fixed_width = true;alignment = centered;"
	        ":toggle {key = \"JB_1_to1\"; label = \"Einfgepunkt picken\";}"
	        ":spacer {width = 2;}"
	        ":toggle {key = \"JB_1_to2\"; label = \"Einfgung im aktuellen Bereich\";}"
	        ":spacer {width = 2;}"
                ":retirement_button {label = \"&Kopieren\"; key= \"accept\";fixed_width=true;is_default = true;}"
                ":spacer {width = 2;}"
                ":retirement_button {label = \"&Ende\"; key= \"cancel\";is_cancel = true; fixed_width=true;}"
                "}}"
                "JB_OCL_2: dialog {label = \"Layerfilter\";"
                ":boxed_column {label = \"Bitte eingeben\";"
                ":edit_box{key = \"JB_2_e1\";edit_width = 50; allow_accept =true;}}"
                "ok_cancel;}"



          )))
    (close file)
    JB_OCL_$DCL$_File)
    )
  )


;;;Aktueller Space fr VLA-Kram
(defun JB_OCL:CurrentSpace ( / )
  (if (or(= (strcase (getvar "CTAB")) "MODEL")
	   (/=(getvar "CVPORT")1))
      (vla-get-ModelSpace (vla-get-ActiveDocument (vlax-get-acad-object)))
      (vla-get-PaperSpace (vla-get-ActiveDocument (vlax-get-acad-object)))
      )
  )



  
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine verwaltungstechnische Funktionen							   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Fehlermeldung
;;;Fehlermeldung;;;
(defun JBf_Error  (s)
  (print (strcat "***Fehler*** " s))
  (JBf_Reinit))

;;;Initialisierungsfunktion
(defun JBf_init (InitVaris / )
  (setq	JB_Error *error*
        *error* JBf_Error)
  (vl-load-com)
  ;;;Systemvariablen aktuelle Einstellungen fr ReInit speichern
  (setq JBf$ReInit$Varis
         (mapcar '(lambda(A)
                    (list (car A)(getvar (car A))))InitVaris))
  ;;;Vorgabeeistellungen fr Systemvariablen
  (mapcar '(lambda(A)
             (if (cadr A)
               (setvar (car A)(cadr A))))InitVaris)
                   
                   
  )
;;;Reinitialisierung
(defun JBf_Reinit ( / n)
  ;;;Systemvariablen ReInitialisieren
  (mapcar '(lambda(A)
             (setvar (car A)(cadr A)))JBf$ReInit$Varis)
  (setq JBf$ReInit$Varis nil)
  (princ)
)
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Strings								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


;;;benutzerspezifischer Pfad zum Speichern von Programmeinstellungen
(defun JBf_String:Userpfad:WinUser (UserPfad / )
  
  (setq UserList (JBf_String:Delimiter->List UserPfad "\\"))
  (setq Pfad (strcat "c:\\Users\\"(getvar "LOGINNAME")"\\"))
        

  ;;;wenn UserPfad noch nicht vorhanden, dann erstellen
  (mapcar '(lambda(A)
             (setq Pfad (strcat Pfad A "\\"))
             (if (not (JBf_String:FilePath? Pfad))
               (vl-mkdir Pfad)))
    UserList)
  Pfad
  )


;;;String anhand Trennzeichen in Liste zurckgeben
(defun JBf_String:Delimiter->List (Str Delim / StrList)
  (setq Str (vl-string-left-trim Delim Str)
	Str (vl-string-right-trim Delim Str))
  (if (vl-string-search Delim Str)
    (progn
      (while (vl-string-search Delim Str)
        (setq StrList (cons (substr Str 1 (vl-string-search Delim Str))StrList)
	      Str (vl-string-left-trim Delim(substr Str(+(vl-string-search Delim Str)(+ (strlen Delim)1))))))
      (if (/= Str "")
        (setq StrList (cons Str StrList))))
    (setq StrList (cons Str StrList)))
  (reverse StrList))

;;;Dateipfad prfen
(defun JBf_String:FilePath? (Pfad / FSO TRUE-FALSE)
  (setq Pfad (if(vl-string-search "." Pfad)(car(fnsplitl  Pfad))Pfad))
  (if (setq FSO (vlax-create-object "Scripting.FilesystemObject"))
    (progn
      (if (vlax-method-applicable-p FSO 'FOLDEREXISTS)
        (setq TRUE-FALSE
               (=(vl-catch-all-apply
                   'vlax-invoke-method
                   (list FSO 'FOLDEREXISTS Pfad)):vlax-true))
        (vlax-release-object FSO))))
  TRUE-FALSE)


;;;Dateipfad krzen (Filename bleibt komplett erhalten), wenn nur Pfad, dann wird in der Mitte getrennt
(defun JBf_String:PathFileName:reduce (PathFileName Lmax / )
  
(if(>(strlen PathFileName)Lmax)
  (if (fnsplitl PathFileName)
    (progn
      (setq FileName (strcat (cadr(fnsplitl PathFileName))(caddr(fnsplitl PathFileName)))
            LPrae (- Lmax (strlen FileName)))
      (if (<= LPrae 0);;;wenn Dateiname grer als Lmax
        (strcat (substr PathFileName 1 (- (/ Lmax 2) (/ Lmax 50)))"..."(substr PathFileName(-(strlen PathFileName)(- (/ Lmax 2) (/ Lmax 50)))))
        (strcat (substr PathFileName 1 (-(- Lmax (strlen FileName))(/ Lmax 50)))"..."
          (substr PathFileName(-(-(strlen PathFileName)(strlen FileName))(/ Lmax 50))))
        )
      )
    (strcat (substr PathFileName 1 (fix (/ Lmax 2.0)))"..."(substr PathFileName (-(strlen PathFileName)(+(fix(/ Lmax 2.0))4)))))
  
  PathFileName)
)



;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Es wird der GcN-Eintrag gesubst
(defun JBf_list:subst:gc (liste Wert GcN / )
  (subst (cons GcN Wert)(assoc GcN liste)liste))



(defun JBf_list:nth:change(liste EintragNew pos / n )
  (setq n -1)
  (mapcar '(lambda (A)
             (setq n (+ n 1))
             (if (= n pos)
               EintragNew
               A))liste))



;;;--------------------------------------------------------------------------------------------------------
;;;alLGZmeine Funktionen => Listen in SIC-Datei sichern  					   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Liste in LSP-Datei sichern
;;;Sichern von Einstellungen, Ausfhrung
;;;liste => DottetPairList, die es zu sichern gilt
;;;path => vollstndiger Dateipfad mit Dateiname
;;;AcadTrustCheck => 'T or NIL, es wird bei 'T ein temnporrer TrustedPath erstellt und danach auch gleich wieder gelscht
(defun JBf_SIC:sichern (liste FilePath AcadTrustCheck / FILESTREAM X)

  (setq FileStream (open FilePath "w"))
  (write-line "'(" FileStream)
  (mapcar '(lambda (X)
                   (JBf_SIC:sichern:prin1 X FileStream)
           )
          liste
  )
  (write-line ")" FileStream)
  (close FileStream)

  (if
    (if AcadTrustCheck
      (car (JBf_SIC:load:Catch FilePath nil))
      (vl-catch-all-error-p
        (vl-catch-all-apply 'JBf_SIC:load (list FilePath))
      )
    )


    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (progn
        (alert (strcat "Die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n ist fehlerhaft und wird automatisch durch die BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nersetzt."
               )
        )
        (if (vl-file-delete FilePath)
          (vl-file-copy (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak") FilePath)
          (alert (strcat "Die Sicherungsdatei \n\n"
                         FilePath
                         "\n\n ist fehlerhaft und konnte nicht automatisch durch die BAK-Datei\n\n"
                         (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                         "\n\nersetzt werden. Bitte fhren Sie diesen Arbeitsgang manuell durch."
                 )
          )
        )
      )

      (alert (strcat "Die Sicherungsdatei \n\n"
                     FilePath
                     "\n\n ist fehlerhaft, bitte lschen Sie diese, anderfalls kann das Programm nicht mehr\n"
                     "ordnungsgem starten."
             )
      )
    )
    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (if (vl-file-delete (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (alert (strcat "Fr die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n konnte keine BAK-Datei erstellt werden. Bitte lschen Sie die vorh. BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nmanuell."
               )
        )
      )
      (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
    )
  )
)
;;;Laden der Datei um zu prfen, ob diese korrekt ist!
  (defun JBf_SIC:load (FilePath /)
    (load FilePath)
  )
;;;Pfad muss existieren, Prfung in aufrufender Funktion und temporrem TrustPath
  (defun JBf_SIC:load:Catch (PathFile ErrMsg / ERROR RETVAL TRUTHPATHSET)
    (if (JBf_AcadSystem:TrustedPaths?)
      (progn
        (setq TruthPathSet 'T)
        (JBf_AcadSystem:TrustedPaths:Add (strcat (car (fnsplitl PathFile)) "..."))
      )
    )

    (setq error (vl-catch-all-error-p
                  (setq RetVal (vl-catch-all-apply 'JBf_SIC:load (list PathFile)))
                )
    )
    (if (and error ErrMsg)
      (alert ErrMsg)
    )

    (if TruthPathSet
      (JBf_AcadSystem:TrustedPaths:Delete (strcat (car (fnsplitl PathFile)) "..."))
    )
    (list error RetVal)
  )
;;;Iteratives lustiges Listenschreiben
  (defun JBf_SIC:sichern:prin1 (A FileStream / B)

    (cond  ;;;wenn einzelner Eintrag
                 ((atom A)
                        (write-line (vl-prin1-to-string A) FileStream)
                 )
      ((and (atom (car A)) (not (cdr A)))  ;;;GC ohne Wert
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (not (listp (cdr A))))  ;;;DottedPair
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)) (= (length (cdr A)) 1) (atom (car (cdr A))))  ;;;GC + Wert
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)))  ;;;GC + Liste
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ( 'T
        (write-line "(" FileStream)
        (mapcar '(lambda (B)
                         (JBf_SIC:sichern:prin1 B FileStream)
                 )
                A
        )
         (write-line ")" FileStream)
      )
    )
  )  



;;;--------------------------------------------------------------------------------------------------------
;;;Setzen von "TrustedPaths's" ab ACAD  2014								   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Prfen, ob bereits TrustedPaths in der aktuelle Version verwendet werden knnen
(defun JBf_AcadSystem:TrustedPaths? ( / )
  (and (= "ACAD" (strcase (getvar "PROGRAM"))) (getvar "SECURELOAD"))
  )

;;;Pfadangaben immer mit BackSlashes, "\\..." hinten angestellt, damit alle untergeordneten Verzeichnisse bercksichtigt werden
(defun JBf_AcadSystem:TrustedPaths:Add (pfad / TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (if(not(member (strcase pfad)(mapcar 'strcase (JBf_AcadSystem:TrustedPath:Split TrustedPaths))))
    (setvar "TRUSTEDPATHS"(strcat TrustedPaths ";" pfad)))
  )

;;;Pfad entfernen
(defun JBf_AcadSystem:TrustedPaths:Delete (pfad / A TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (setvar "TRUSTEDPATHS"
	  (vl-string-right-trim ";"(apply 'strcat(mapcar '(lambda(A)
							   (strcat A ";"))
							(vl-remove-if 'not (mapcar '(lambda(A)
										      (if(/= (strcase pfad)(strcase A))A))
										   (JBf_AcadSystem:TrustedPath:Split TrustedPaths)))))))
  )
			     

;;;String splitten an Semikolons, als Liste zurckgeben
(defun JBf_AcadSystem:TrustedPath:Split (TrustedPaths / A RETLIST TEMP)
  (mapcar '(lambda(A)
	     (if (/= A 59)
	       (setq temp (cons A temp))
	       (setq RetList (cons (vl-list->string(reverse temp))RetList)
		     temp nil))
	     )
	     (vl-string->list TrustedPaths))
  (if temp
    (setq RetList (cons (vl-list->string (reverse temp))RetList)))
  (reverse RetList))

;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Dcl									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



;;;DCL-Dialogfenster laden
(defun JBf_Dcl:Load_dialog (FileName DialogName JB_$DCL$_x_po / DclId)
  (setq DclId (load_dialog FileName))
  (if	JB_$DCL$_x_po
    (if (not (new_dialog DialogName DclId "" JB_$DCL$_x_po))
      (exit))
    (if (not (new_dialog DialogName DclId))
      (exit)))
  DclId
  )



;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Progress								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Progress_01-INI => es wird die DCL-Datei geschrieben!
(defun JBf_progress_01:Ini ( / )
  (if (not
        (or (and JBf_progress_01$DCL$_File(findfile JBf_progress_01$DCL$_File))
            (setq JBf_progress_01$DCL$_File (JBf_progress_01:DclWrite))))
            (progn
              (alert "Die DCL-Datei konnte nicht geschrieben werden.")
              (exit)))
)

;;;DCL-Datei schreiben
(defun JBf_progress_01:DclWrite (/ A FILE)
  (if (and (setq JBf_progress_01$DCL$_File (vl-filename-mktemp (strcat "JBf_progress_01.dcl")))
           (setq file (open JBf_progress_01$DCL$_File "w"))
      )
    (progn
      (mapcar '(lambda (A)
                       (write-line A file)
               )
              (mapcar '(lambda (A)
                               (strcat "\n" A)
                       )
              '(


                 "JBf_Progress_01_1 : dialog {key = \"JB_1_d\";label = \"\"; spacer;"
                 ":row{"
                 ":text{key = \"JB_1_t1\"; label = \"\";}"
                 ":image {key = \"cancel\";is_cancel=true;width = 0.5; height = 0.5;fixed_width = true;fixed_height = true;aspect_ratio = 1; color = -15;vertical_margin = none;}}"
                 ":row{"
                 ":column{"
                 ":spacer{ height = 0.12; fixed_height = true;}"
                 ":image{key = \"JB_1_i1\";width = 58.92; fixed_width = true;height = 1.51; fixed_height = true;aspect_ratio = 1;color = -15; vertical_margin = none;}"
                 "       }"
                 "//spacer;}"
                 "}"
                 ":text {key = \"JB_1_t3\";label = \"\";}"
                 ":row {"
                 ":text{key = \"JB_1_t2\";label = \"\";}"
                 "     }"
                 "//ok_only;"
                 "}"
                 "JBf_Progress_01_Counter_1 : dialog {key = \"JB_1_d\";label = \"\"; spacer;"
                 ":row{"
                 ":image{key = \"JB_1_i1\";width = 4; fixed_width = true;height = 2; fixed_height = true;aspect_ratio = 1;color = -15; vertical_margin = none;}"
                 ":text_part{key = \"JB_1_t1\"; label = \"Zeile\";width=20;}"
                 ":text_part{key = \"JB_1_t2\";label= \"1\";width=6;}"
                 ":image {key = \"cancel\";is_cancel=true;width = 0.5; height = 0.5;fixed_width = true;fixed_height = true;aspect_ratio = 1; color = -15;vertical_margin = none;}"
                 "}"
                 "//ok_only;"
                 "}"
                 "JBf_Progress_01_Counter_2 : dialog {key = \"JB_1_d\";label = \"\"; spacer;"
                 ":row{"
                 ":image{key = \"JB_1_i1\";width = 5.42; height = 2.51; fixed_height = true;aspect_ratio = 1;color = -15; vertical_margin = none;}"
                 ":text_part{key = \"JB_1_t1\"; label = \"Zeile\";width=20;}"
                 ":text_part{key = \"JB_1_t2\";label= \"1\";width=20;}"
                 ":image {key = \"cancel\";is_cancel=true;width = 0.5; height = 0.5;fixed_width = true;fixed_height = true;aspect_ratio = 1; color = -15;vertical_margin = none;}"
                 "}"
                 "//ok_only;"
                 "}"




               )
              )
      )
      (close file)
      JBf_progress_01$DCL$_File
    )
  )
)

;;;Prozenzwert aus l (Gesamtlnge) und n (aktueller Stand)
(defun JBf_progress_01:prz (l n / )
  (/(* n 100)l)
)

;;;Standard-ProgressBar starten
(defun JBf_progress_01:DBox:Start (Titel l msg /)
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (JBf_progress_01:Ini)
      (setq JBf_progress_01$$dat (load_dialog JBf_progress_01$DCL$_File))
      (if (not (new_dialog "JBf_Progress_01_1" JBf_progress_01$$dat "" '(-1 -1))) (exit))

      (if Titel (set_tile "JB_1_d" Titel))
      (if msg (set_tile "JB_1_t3" msg))

      (setq JBf_progress_01$$Xi1 (1- (dimx_tile "JB_1_i1")))
      (setq JBf_progress_01$$Yi1 (1- (dimy_tile "JB_1_i1")))

      (JBf_progress_01:DBox:Start:i1:Frame)
      (if redraw_dialog (redraw_dialog)) ;; bricsys - if new "redraw_dialog" is available

      (setq JBf_progress_01$$n 0)
      (setq JBf_progress_01$$l l)
      (setq JBf_progress_01$$prz 0)
      
    )
  )
)


;;;Standard-ProgressBar Fortschritt
(defun JBf_progress_01:DBox:Fortschritt (/ prz)
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (setq JBf_progress_01$$n (+ JBf_progress_01$$n 1))
      (if (= JBf_progress_01$$n JBf_progress_01$$l)
        (setq prz 100)
        (setq prz (JBf_progress_01:prz JBf_progress_01$$l JBf_progress_01$$n))
      )

      
      (if (> prz JBf_progress_01$$prz)
        (progn
          (set_tile "JB_1_t1" (strcat "(" (itoa JBf_progress_01$$n) " von " (itoa JBf_progress_01$$l) ")"))
          (JBf_progress_01:DBox:Start:i1:Balken prz)
          (set_tile "JB_1_t2" (strcat (itoa prz) "% erledigt."))
          (if redraw_dialog (redraw_dialog)) ;; bricsys - if new "redraw_dialog" is available
          (setq JBf_progress_01$$prz prz)
        )
      )
                                     
    )
  )
)

;;;Nur Statusmeldung ohne Progressbalken
(defun JBf_progress_01:DBox:Status (msg /)
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (set_tile "JB_1_t3" msg)
      (if redraw_dialog (redraw_dialog)) ;; bricsys - if new "redraw_dialog" is available
    )
  )
)

;;;Beenden der ProgressBar
(defun JBf_progress_01:DBox:End (/)
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (done_dialog)
      ;(start_dialog)
      (if JBf_progress_01$$dat
        (progn
          (unload_dialog JBf_progress_01$$dat)
          (setq JBf_progress_01$$dat nil
                JBf_progress_01$$Xi1 nil
                JBf_progress_01$$Yi1 nil
                
                JBf_progress_01$$n nil
                JBf_progress_01$$l nil
                JBf_progress_01$$prz nil
          )
        )
      )
    )
  )
)

;;;Beenden, Variablen so belassen wie sie sind fr nchsten Start an gleicher Stelle
(defun JBf_progress_01:DBox:End:ohneReinit (/)
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (done_dialog)
      ;(start_dialog)
      (if JBf_progress_01$$dat
        (unload_dialog JBf_progress_01$$dat)
      )
      (setq JBf_progress_01$$n (- JBf_progress_01$$n 1))
      (setq JBf_progress_01$$prz (- JBf_progress_01$$prz 1));;;damit der Balken refresht wird
      
    )
  )
)


;;;Standard-ProgressBar starten
(defun JBf_progress_01:DBox:ReStart:ohneInit (Titel l msg /)
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (JBf_progress_01:Ini)
      (setq JBf_progress_01$$dat (load_dialog JBf_progress_01$DCL$_File))
      (if (not (new_dialog "JBf_Progress_01_1" JBf_progress_01$$dat "" '(-1 -1))) (exit))

      (if Titel (set_tile "JB_1_d" Titel))
      (if msg (set_tile "JB_1_t3" msg))      

      (JBf_progress_01:DBox:Start:i1:Frame)
      (JBf_progress_01:DBox:Fortschritt)
      (if redraw_dialog (redraw_dialog)) ;; bricsys - if new "redraw_dialog" is available
      
            
    )
  )
)



  
;;;Rahmen zeichnen
(defun JBf_progress_01:DBox:Start:i1:Frame (/ i1X i1Y)
  
   (setq i1X JBf_progress_01$$Xi1
        i1Y JBf_progress_01$$Yi1
  )
  (start_image "JB_1_i1")
  (vector_image 1 4 4 1 8)
     (vector_image 4 1 (- i1X 4) 1 8)
	     
	     (vector_image (- i1X 4) 1 (- i1X 1) 4 8)
	     
	     (vector_image (- i1X 1) 4 (- i1X 1) (- i1Y 4) 8)
	     
	     (vector_image (- i1X 1) (- i1Y 4) (- i1X 4) (- i1Y 1) 8)
	     
	     (vector_image (- i1X 4) (- i1Y 1) 4 (- i1Y 1) 8)
	     
	     (vector_image  4 (- i1Y 1) 1 (- i1Y 4) 8)
	     (vector_image  1 (- i1Y 4) 1 4 8)
  (end_image)
)

;;;ProgressBalken im Aufbau 
(defun JBf_progress_01:DBox:Start:i1:Balken (prz / i1X i1Y)

(if (= 100 prz)
    (setq i1X (- JBf_progress_01$$Xi1 7))
    (setq i1X (atoi(rtos(+(*(/(- JBf_progress_01$$Xi1 7)100.0)prz)2)2 0)))
    )
  (setq i1Y JBf_progress_01$$Yi1)
  
  (start_image "JB_1_i1")
  (fill_image 4 4 i1X (- i1Y 7) 74)

  (end_image)
  )




;;;Beenden der ProgressCounter
(defun JBf_progress_01:Counter:End ( / )
  (if (not JB_Bosse_tools$$DebugModus)
    (progn
      (done_dialog)
      ;(start_dialog)
      (if JBf_progress_01$$dat
        (progn
          (unload_dialog JBf_progress_01$$dat)
          (setq JBf_progress_01$$dat nil JBf_progress_01$$CounterN nil JBf_progress_01$$CounterX nil JBf_progress_01$$CounterY nil)
      )
    )
  )
)
)




;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => DBX									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Rckgabe: gltiges DBX-Objekt fr aktuelle Version
(defun JBf_DBX:Open:GetVS (vs / DBX)
  (if(not(vl-catch-all-error-p
           (setq DBX (vl-catch-all-apply
                       'vla-GetInterfaceObject
                       (list
                         (vlax-get-acad-object)
                         vs)))
           ))DBX))
;;;DBX-Objekt
(defun JBf_DBX ( / DBX)
  (if (>=(setq vs (atoi (getvar "ACADVER")))15)
    (JBf_DBX:Open:GetVS (strcat "ObjectDBX.AxDbDocument."(itoa vs)))
    (JBf_DBX:Open:GetVS "ObjectDBX.AxDbDocument")
  )
)
 

;;;DWG-Datei als DBX-Object ffnen (nur, wenn gltig und nicht schreibgeschtzt
(defun JBf_DBX:Open(DBX dwgname / )
  (not(vl-catch-all-error-p   
        (vl-catch-all-apply 'vla-open(list DBX dwgname)))))
;;;DBX-Object wieder freigeben
(defun JBf_DBX:Release(DBX / )
  (not(vl-catch-all-error-p
        (vl-catch-all-apply
          'vlax-release-object(list DBX)
          ))))
;;;DBX-Objekt speichern


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Zoom								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;aktueller Bildschirmmittelpunkt
(defun JBf_Zoom:BildschirmMittelpunkt ( / )
  (mapcar '(lambda(A)(/ A 2.0))
  (mapcar '+
  (list (- (car (getvar "viewctr")) (/ (* (getvar "viewsize") (/ (car (getvar "screensize")) (cadr (getvar "screensize")))) 2))
        (- (cadr (getvar "viewctr")) (/ (getvar "viewsize") 2))0.0)
  (list (+ (car (getvar "viewctr")) (/ (* (getvar "viewsize") (/ (car (getvar "screensize")) (cadr (getvar "screensize")))) 2))
        (+ (cadr (getvar "viewctr")) (/ (getvar "viewsize") 2))
        0))))
  


;;;--------------------------------------------------------------------------------------------------------
;;;Info fr Textfenster nach dem laden des Programms							   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(princ (strcat
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          "\n|ObjCopyByLayer: Objekte kopieren aus Datei mit Layerfilter. |"
          "\n|------------------------------------------------------------|"
          "\n|erstellt durch Bosse-engineering - www.bosse-engineering.com|"
          "\n|------------------------------------------------------------|"
          "\n|Befehlszeilenaufruf: OCL oderOBJCOPYBYLAYER.                |"
	  "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          )
       )

(princ)








    

